-- DOORS Cheat GUI (ESP, Speed, Noclip, Auto-Dodge, Item Spawner, Auto-Win)
local Players = game:GetService("Players")
local LocalPlayer = Players.LocalPlayer
local Workspace = game:GetService("Workspace")
local UIS = game:GetService("UserInputService")
local RunService = game:GetService("RunService")
local ReplicatedStorage = game:GetService("ReplicatedStorage")

-- Create UI
local ScreenGui = Instance.new("ScreenGui")
local MainFrame = Instance.new("Frame")

ScreenGui.Parent = game.CoreGui
ScreenGui.ResetOnSpawn = false

MainFrame.Parent = ScreenGui
MainFrame.Size = UDim2.new(0, 230, 0, 450)
MainFrame.Position = UDim2.new(0.1, 0, 0.1, 0)
MainFrame.BackgroundColor3 = Color3.fromRGB(30, 30, 30)
MainFrame.BorderSizePixel = 2
MainFrame.Active = true

local function createButton(text, position)
    local button = Instance.new("TextButton")
    button.Parent = MainFrame
    button.Size = UDim2.new(0, 200, 0, 40)
    button.Position = UDim2.new(0.05, 0, position, 0)
    button.BackgroundColor3 = Color3.fromRGB(50, 50, 50)
    button.Text = text
    button.TextColor3 = Color3.fromRGB(255, 255, 255)
    button.Font = Enum.Font.SourceSansBold
    button.TextSize = 20
    button.BorderSizePixel = 2
    return button
end

local ESPButton = createButton("Toggle ESP", 0.05)
local SpeedButton = createButton("Toggle Speed Boost", 0.2)
local NoclipButton = createButton("Toggle Noclip", 0.35)
local AutoWinButton = createButton("Auto-Win Door 50", 0.5)
local AutoDodgeButton = createButton("Auto-Dodge Rush/Ambush", 0.65)
local UnlockDoorsButton = createButton("Unlock All Doors", 0.8)
local GodModeButton = createButton("Enable God Mode", 0.95)
local TeleportButton = createButton("Teleport to Any Room", 1.1)
local ItemSpawnButton = createButton("Spawn ALL Items", 1.25)

-- Dragging UI
local dragging, dragInput, dragStart, startPos

local function updateInput(input)
    local delta = input.Position - dragStart
    MainFrame.Position = UDim2.new(startPos.X.Scale, startPos.X.Offset + delta.X, startPos.Y.Scale, startPos.Y.Offset + delta.Y)
end

MainFrame.InputBegan:Connect(function(input)
    if input.UserInputType == Enum.UserInputType.MouseButton1 or input.UserInputType == Enum.UserInputType.Touch then
        dragging = true
        dragStart = input.Position
        startPos = MainFrame.Position

        input.Changed:Connect(function()
            if input.UserInputState == Enum.UserInputState.End then
                dragging = false
            end
        end)
    end
end)

MainFrame.InputChanged:Connect(function(input)
    if input.UserInputType == Enum.UserInputType.MouseMovement or input.UserInputType == Enum.UserInputType.Touch then
        dragInput = input
    end
end)

UIS.InputChanged:Connect(function(input)
    if input == dragInput and dragging then
        updateInput(input)
    end
end)

-- ESP Function
local ESPEnabled = false
local function highlightEntity(entity)
    if entity:IsA("Model") and entity:FindFirstChild("HumanoidRootPart") then
        local highlight = Instance.new("Highlight")
        highlight.Parent = entity
        highlight.FillColor = Color3.fromRGB(255, 0, 0)
        highlight.OutlineColor = Color3.fromRGB(255, 255, 255)
        highlight.DepthMode = Enum.HighlightDepthMode.AlwaysOnTop
    end
end

ESPButton.MouseButton1Click:Connect(function()
    ESPEnabled = not ESPEnabled
    ESPButton.Text = ESPEnabled and "ESP ON" or "ESP OFF"

    if ESPEnabled then
        for _, entity in pairs(Workspace:GetChildren()) do
            highlightEntity(entity)
        end
    else
        for _, entity in pairs(Workspace:GetChildren()) do
            if entity:IsA("Model") and entity:FindFirstChild("Highlight") then
                entity.Highlight:Destroy()
            end
        end
    end
end)

-- Auto-Win for Door 50
AutoWinButton.MouseButton1Click:Connect(function()
    for _, v in pairs(Workspace:GetDescendants()) do
        if v.Name == "LibraryPuzzle" then
            v:Destroy()
        end
    end
    AutoWinButton.Text = "Auto-Win Activated!"
end)

-- Auto-Dodge Rush & Ambush
AutoDodgeButton.MouseButton1Click:Connect(function()
    local function onEntitySpawn(entity)
        if entity:IsA("Model") and (entity.Name == "Rush" or entity.Name == "Ambush") then
            LocalPlayer.Character.HumanoidRootPart.CFrame = Workspace.Closets:GetChildren()[1].CFrame
        end
    end

    Workspace.ChildAdded:Connect(onEntitySpawn)
    AutoDodgeButton.Text = "Auto-Dodge ON"
end)

-- Unlock All Doors
UnlockDoorsButton.MouseButton1Click:Connect(function()
    for _, door in pairs(Workspace:GetChildren()) do
        if door:IsA("Model") and door.Name:match("Door") and door:FindFirstChild("Lock") then
            door.Lock:Destroy()
        end
    end
    UnlockDoorsButton.Text = "Doors Unlocked!"
end)

-- God Mode
GodModeButton.MouseButton1Click:Connect(function()
    for _, part in pairs(LocalPlayer.Character:GetDescendants()) do
        if part:IsA("BasePart") then
            part.Anchored = true
        end
    end
    GodModeButton.Text = "God Mode Enabled!"
end)

-- Teleport to Any Room
TeleportButton.MouseButton1Click:Connect(function()
    local targetRoom = Workspace:FindFirstChild("50")
    if targetRoom then
        LocalPlayer.Character.HumanoidRootPart.CFrame = targetRoom.CFrame
    end
    TeleportButton.Text = "Teleported!"
end)

-- Item Spawner
ItemSpawnButton.MouseButton1Click:Connect(function()
    local function giveItem(itemName)
        local item = ReplicatedStorage:FindFirstChild(itemName):Clone()
        if item then
            item.Parent = LocalPlayer.Backpack
        end
    end

    giveItem("Crucifix")
    giveItem("SkeletonKey")
    giveItem("Candle")
    giveItem("Lighter")
    giveItem("Vitamins")
    giveItem("Lockpick")
    giveItem("Flashlight")

    ItemSpawnButton.Text = "All Items Spawned!"
end)
